import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import {userQuery} from "../../../../api/queries";
import {findById} from "../../../../utils";
import Loading from "../../../../core/Loading/Loading";
import UsersForm from "../../../../core/Forms/UsersForm/UsersForm";

class Edit extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
    }

    render() {
        const {
            data
        } = this.props;

        if(data.loading) {
            return (<Loading/>);
        }

        return (<div className="container" style={{marginBottom: '20px'}}>
            <h1>Salva Utente</h1>
            <UsersForm
                data={data}
                submitMutation={gql`
                    mutation($utente: UtenteInput) {
                        updateUtente(monitoraggioSpecie: $utente) {
                            id
                        }
                    }`} />
        </div>);
    }
}

export default compose(
    graphql(userQuery, {
        options:({match}) => ({variables: {id: match.params.id}}),
    })
)(Edit);

Edit.defaultProps = {};

Edit.propTypes = {};